/*
 Eloquence WEBDLG v2 Plugin Example: Filetransfer
 (C) Copyright Marxmeier Software AG, 2024-2025
 $Id: webdlg-filetransfer.js,v 29.5 2025/10/21 14:17:07 rhg Exp $
*/
eq.plugin("Filetransfer",{atr:[["buffer",eq.atrGET|eq.atrSET|eq.atrINT|eq.atrNOC],["select",eq.atrGET|eq.atrSET|eq.atrSTR|eq.atrLST|eq.atrNOC|eq.atrSYN],["upload",eq.atrGET|eq.atrSTR|eq.atrNOC|eq.atrSYN],["download",eq.atrGET|eq.atrSTR|eq.atrNOC|eq.atrSYN],["transfer",eq.atrGET|eq.atrSET|eq.atrSTR|eq.atrLST|eq.atrNOC|eq.atrSYN],["close",eq.atrSET|eq.atrINT|eq.atrNOC|eq.atrSYN]],prp:{minVersion:3,classList:"filetransfer",changeEvent:"change",focusable:!1},apiInit:function(a,f){a=this.constructor;void 0===
a.defaultFileName&&(a.defaultFileName=eq.strings.get("filetransfer.file.name"),a.defaultFileName||(a.defaultFileName="webdlg-download.dat"),a.defaultFileType=eq.strings.get("filetransfer.file.type"),a.defaultFileType||(a.defaultFileType="application/octet-stream"))},apiSetAttr:function(a,f,e,d,b,c){a=this.constructor;switch(d){case "buffer":a.bufferSize=c.i;break;case "select":a.setOptions(c.s);break;case "transfer":a.transfer.setNext(c.s);break;case "close":c.i?a.transfer.done():a.transfer.close()}},
apiGetAttr:function(a,f,e,d,b){b=this.constructor;switch(d){case "buffer":return 0>=b.bufferSize&&(b.bufferSize=32766),b.bufferSize;case "select":return b.getOptions();case "upload":return b.transfer.start(new b.upload(this,a,f,e));case "download":return b.transfer.start(new b.download(this,e));case "transfer":return b.transfer.getNext()}},static:{install:function(){this.bufferSize=0;this.byteToHex=[];for(var a=0;256>a;a++)this.byteToHex.push(a.toString(16).padStart(2,"0"))},dispose:function(){this.transfer.close();
this.options&&(this.cleanupFilters(),this.options.clear(),this.options=null)},transfer:{start:function(a){this.close();return(this.op=a).start(this)},startTimer:function(){this.timeout&&clearTimeout(this.timeout);this.timeout=setTimeout(this.close,1E4)},setNext:function(a){if(this.op&&this.op.setNext)return this.op.setNext(a)},getNext:function(){if(this.op&&this.op.getNext)return this.op.getNext()},done:function(){this.op&&this.op.done&&this.op.done();this.close()},close:function(){this.op&&(this.op.dispose(),
this.op=void 0);this.timeout&&(clearTimeout(this.timeout),this.timeout=void 0)}},upload:function(a,f,e,d){this.transfer=null;this.obj=a;this.dlg=f;this.id=e;this.el=d;this.pending=!0;this.start=function(b){var c=this,k=this.obj.constructor,g=document.createElement("INPUT");0>=k.bufferSize&&(k.bufferSize=8E3);g.type="file";k.setFileSelectorFilters(g);g.style.display="none";this.el.appendChild(g);g.onchange=function(){if(1!==g.files.length)b.close();else{var h=g.files[0];c.el.textContent="";c.el=void 0;
c.pending=!1;c.obj.onUpdateReturn(c.dlg,c.id,"file="+h.name+"\ntype="+h.type+"\nsize="+h.size+"\n");c.rd=new FileReader;c.rd.onloadend=function(){c.rd.result?(c.data=new Uint8Array(c.rd.result),c.rd=void 0,c.offs=0,(c.transfer=b).startTimer(),c.pending&&(c.pending=!1,c.obj.onUpdateReturn(c.dlg,c.id,c.returnData()))):(c.rd=void 0,b.close())};c.rd.readAsArrayBuffer(h)}};g.oncancel=function(){b.close()};g.click();return null};this.returnData=function(){if(this.data&&this.offs<this.data.length){var b=
this.obj.constructor,c=b.byteToHex;b=this.data.slice(this.offs,this.offs+b.bufferSize/2);var k=b.length,g=[];this.offs+=k;g.length=k;for(var h=0;h<k;h++)g[h]=c[b[h]];return g.join("")}this.data=void 0};this.getNext=function(){if(void 0!==this.offs)return this.transfer.startTimer(),this.returnData();this.pending=!0;return null};this.dispose=function(){if(this.pending){this.pending=!1;try{this.obj.onUpdateReturn(this.dlg,this.id,void 0)}catch(b){}}this.el&&(this.el.textContent="",this.el=void 0);this.rd&&
(this.rd.abort(),this.rd=void 0);this.offs=this.data=this.id=this.dlg=this.obj=this.transfer=void 0}},download:function(a,f){this.transfer=null;this.obj=a;this.el=f;this.data=[];this.start=function(e){var d=this.obj.constructor;if(d.options){var b=d.options.get("type");var c=d.options.get("file")}b||(b=d.defaultFileType);c||(c=d.defaultFileName);(this.transfer=e).startTimer();return"file="+c+"\ntype="+b+"\n"};this.setNext=function(e){var d=e.length;if(d%2)console.error("BUG: Filetransfer.download.setNext odd data length"),
this.transfer.close();else{for(var b=0;b<d;b+=2)this.data.push(parseInt(e.substring(b,b+2),16));this.transfer.startTimer()}};this.done=function(){if(0<this.data.length){var e=this.obj.constructor;if(e.options){var d=e.options.get("type");var b=e.options.get("file")}d||(d=e.defaultFileType);b||(b=e.defaultFileName);e=(window.URL||window.webkitURL).createObjectURL(new Blob([(new Uint8Array(this.data)).buffer],{type:d}));this.data.length=0;this.data=void 0;d=document.createElement("A");d.href=e;d.download=
b;d.style.display="none";this.el.appendChild(d);d.click();(window.URL||window.webkitURL).revokeObjectURL(e)}};this.dispose=function(){this.el&&(this.el.textContent="",this.el=void 0);this.data&&(this.data.length=0,this.data=void 0);this.obj=this.transfer=void 0}},setOptions:function(a){this.options||(this.options=new Map);var f=null;a=a.split("\n");for(var e,d,b,c,k,g=0,h=a.length;g<h;g++)if(d=(e=a[g].split("=")).length)"filter"===(b=e[0])?(f||this.cleanupFilters(),2===d&&(k=(c=e[1].split("|")).length)&&
(b=c[0]).length&&(1===k?f&&f.delete(b):(f||this.options.set("filter",f=new Map),f.set(b,c.slice(1))))):b.length&&(2===d?this.options.set(b,e[1]):this.options.delete(b))},getOptions:function(){if(this.options){var a={self:this,s:""};this.options.forEach(this.getOption,a);return a.s}return""},getOption:function(a,f){"filter"===f?a.forEach(this.self.getFilterOption,this):this.s+=f+"="+a+"\n"},getFilterOption:function(a,f){this.s+="filter="+f+"|"+a.join("|")+"\n"},setFileSelectorFilters:function(a){var f;
if(this.options&&(f=this.options.get("filter"))){var e=[];f.forEach(this.getFilterExt,e);e.length&&(a.accept="."+e.join(",."))}},getFilterExt:function(a){for(var f=0,e=a.length;f<e;f++){var d=a[f];d.length&&this.push(d)}},cleanupFilters:function(){var a=this.options.get("filter");a&&(a.forEach(this.cleanupFilter),a.clear(),this.options.delete("filter"))},cleanupFilter:function(a){a.length=0}}});
//# sourceMappingURL=webdlg-filetransfer.map
